<?php

use Codexpert\CoDesigner_Pro\Helper;
$settings                       = $args['settings'];
$coupon_label_txt               = $settings['coupon_label_txt'];
$coupon_btn_txt                 = $settings['coupon_btn_txt'];
$coupon_desc_txt                = $settings['coupon_desc_txt'];
$coupon_apply_txt               = $settings['coupon_apply_txt'];
$progress_show_hide       = $args['settings']['progress_temp5_show_hide'];
$progress_billing_txt     = $args['settings']['progress_temp5_billing_txt'];
$progress_shipping_txt    = $args['settings']['progress_temp5_shipping_txt'];
$progress_order_inf_txt   = $args['settings']['progress_temp5_order_inf_txt'];
$progress_payment_inf_txt = $args['settings']['progress_temp5_payment_inf_txt'];
$back_to_cart_show_hide   = $args['settings']['back_to_cart_show_hide_temp5'];
$back_to_cart_txt         = $args['settings']['back_to_cart_txt_temp5'];
$nxt_btn_txt              = $args['settings']['nxt_btn_txt_temp5'];
$prev_btn_txt             = $args['settings']['prev_btn_txt_temp5'];
$order_btn_txt            = $args['settings']['order_btn_txt_temp5'];

if ( class_exists( 'WooCommerce' ) ) {
    $cart            = WC()->cart;
    $cart_contents   = $cart->get_cart();
    $checkout        = WC()->checkout;
    $billing_fields  = $checkout->get_checkout_fields( 'billing' );
    $shipping_fields = $checkout->get_checkout_fields( 'shipping' );
}
?>
<!--== Coupon Form Section Starts Here ==-->
<div id="temp5-cd-coupon">
    <div class="woocommerce-form-coupon-toggle" id="cd-coupon-form">
        <?php wc_print_notice( apply_filters( 'woocommerce_checkout_coupon_message', esc_html__( $coupon_label_txt, 'woocommerce' ) . ' <a href="#" class="showcoupon">' . esc_html__( $coupon_btn_txt, 'woocommerce' ) . '</a>' ), 'notice' ); ?>
    </div>

    <form id="cd-coupon-main" class="checkout_coupon woocommerce-form-coupon" method="post" style="display:none">

        <p><?php esc_html_e( $coupon_desc_txt, 'woocommerce' ); ?></p>

        <div class="cd-coupon-from-row">
            <p class="form-row form-row-first">
                <label for="coupon_code" class="screen-reader-text"><?php esc_html_e( 'Coupon:', 'woocommerce' ); ?></label>
                <input type="text" name="coupon_code" class="input-text" placeholder="<?php esc_attr_e( 'Coupon code', 'woocommerce' ); ?>" id="coupon_code" value="" />
            </p>
    
            <p class="form-row form-row-last">
                <button type="submit" class="button<?php echo esc_attr( 'button' ); ?>" name="apply_coupon" value="<?php esc_attr_e( 'Apply coupon', 'woocommerce' ); ?>"><?php esc_html_e( $coupon_apply_txt, 'woocommerce' ); ?></button>
            </p>
        </div>
    </form>
</div>
<!--== Coupon Form Section Ends Here ==-->

<div class='cd-checkout-template-5'>
    <form name="checkout" method="post" class="checkout woocommerce-checkout" action="<?php echo esc_url( wc_get_checkout_url() ); ?>" enctype="multipart/form-data">
        <div class="cd-checkout-steps">
            <ul class="cd-progressbar">
                <li class='active'>
                    <div class='cd-temp-5-top'>
                        <div class='cd-single-progressbar'>
                            <span class="dashicons dashicons-yes"></span>
                            <span class='cd-step-number'>
                                <?php _e( '1', 'codesigner-pro' ); ?>
                            </span>
                        </div>
                    </div>
                    <div class='cd-temp-5-bottom'>
                        <?php if ( 'yes' == $progress_show_hide ) : ?>
                            <?php esc_html_e( $progress_billing_txt ); ?>
                        <?php endif; ?>
                    </div>
                    <img src="<?php echo plugin_dir_url( __FILE__ ); ?>Vector.svg" alt="">
                </li>
                <li>
                    <div class='cd-temp-5-top'>
                        <div class='cd-single-progressbar'>
                            <span class="dashicons dashicons-yes"></span>
                            <span class='cd-step-number'>
                                <?php _e( '2', 'codesigner-pro' ); ?>
                            </span>
                        </div>
                    </div>
                    <div class='cd-temp-5-bottom'>
                        <?php if ( 'yes' == $progress_show_hide ) : ?>
                            <?php esc_html_e( $progress_shipping_txt ); ?>
                        <?php endif; ?>
                    </div>
                    <img src="<?php echo plugin_dir_url( __FILE__ ); ?>Vector.svg" alt="">
                </li>
                <li> 
                    <div class='cd-temp-5-top'>
                        <div class='cd-single-progressbar'>
                            <span class="dashicons dashicons-yes"></span>
                            <span class='cd-step-number'>
                                <?php _e( '3', 'codesigner-pro' ); ?>
                            </span>
                        </div>
                    </div>
                    <div class='cd-temp-5-bottom'>
                        <?php if ( 'yes' == $progress_show_hide ) : ?>
                            <?php esc_html_e( $progress_order_inf_txt ); ?>
                        <?php endif; ?>
                    </div>
                    <img src="<?php echo plugin_dir_url( __FILE__ ); ?>Vector.svg" alt="">
                <li>
                    <div class='cd-temp-5-top'>
                        <div class='cd-single-progressbar'>
                            <span class="dashicons dashicons-yes"></span>
                            <span class='cd-step-number'>
                                <?php _e( '4', 'codesigner-pro' ); ?>
                            </span>
                        </div>
                    </div>
                    <div class='cd-temp-5-bottom'>
                        <?php if ( 'yes' == $progress_show_hide ) : ?>
                            <?php esc_html_e( $progress_payment_inf_txt ); ?>
                        <?php endif; ?>
                    </div>
                </li>
            </ul>
        </div>
        <div class='cd-steps-content-warpper'>
            <!--Billing Fields-->
            <div class="billing-address">
                <div class="cd-checkout-steps-content">
                    <div class="cd-checkout-info">
                        <div class="cd-checkout-info-input">
                            <?php do_action( 'woocommerce_before_checkout_billing_form', $checkout ); ?>
                            <div id="cd-checkout-info-input-1">
                                <?php
                                foreach ( $billing_fields as $key => $field ) {
                                    woocommerce_form_field( $key, $field, $checkout->get_value( $key ) );
                                }
                                ?>
                            </div>
                        </div>
                        <div class="cd-footer">
                            <div class="cd-back-to-cart">
                                <?php if ( 'yes' == $back_to_cart_show_hide ) : ?>
                                    <span class="dashicons dashicons-arrow-left-alt"></span>
                                    <a href="<?php echo wc_get_cart_url(); ?>" class="cd-priv-btn"><?php esc_html_e( $back_to_cart_txt ); ?></a>
                                <?php endif; ?>
                            </div>
                            <div class="cd-back-to-next">
                                <?php if ( 'yes' == $back_to_cart_show_hide ) : ?>
                                    <button type="button" class='cd-next-btn'><?php esc_html_e( $nxt_btn_txt ); ?></button>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!--Shipping Fields-->
            <div class="shipping-address">
                <div class="cd-checkout-steps-content">
                    <div class="cd-checkout-info shipping">
                        <div class="cd-checkout-info-input ">
                            <?php do_action( 'woocommerce_before_checkout_shipping_form', $checkout ); ?>
                            <div id="cd-checkout-info-input-1">
                                <?php
                                foreach ( $shipping_fields as $key => $field ) {
                                    woocommerce_form_field( $key, $field, $checkout->get_value( $key ) );
                                }
                                ?>
                            </div>
                        </div></br>
                        <div class="order-notes">
                            <p class="form-row notes" id="order_comments_field">
                                <label for="order_comments"><?php _e( "Order Notes" , 'woocommerce'); ?></label>
                                <textarea name="order_comments" class="input-text" id="order_comments" placeholder="<?php esc_attr_e('Notes about your order, e.g. special notes for delivery.', 'woocommerce'); ?>"></textarea>
                            </p>
                        </div>
                        <div class="cd-footer">
                            <div class="cd-back-to-cart">
                                <?php if ( 'yes' == $back_to_cart_show_hide ) : ?>
                                    <span class="dashicons dashicons-arrow-left-alt"></span>
                                    <a href="<?php echo wc_get_cart_url(); ?>" class="cd-priv-btn"><?php esc_html_e( $back_to_cart_txt ); ?></a>
                                <?php endif; ?>
                            </div>
                            <div class='cd-step-wrapper'>
                                <div class="cd-previous">
                                    <?php if ( 'yes' == $back_to_cart_show_hide ) : ?>
                                        <button type="button" class='cd-priv-btn'>
                                            <?php esc_html_e( $prev_btn_txt ); ?>
                                        </button>
                                    <?php endif; ?>
                                </div>
                                <div class="cd-back-to-next">
                                    <?php if ( 'yes' == $back_to_cart_show_hide ) : ?>
                                        <button type="button" class='cd-next-btn'><?php esc_html_e( $nxt_btn_txt ); ?></button>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!--Order Info-->
            <div class="order-summary">
                <div class="cd-checkout-steps-content">
                    <div class="cd-checkout-info order">
                        <div class="cd-checkout-info-input">
                            <?php do_action( 'woocommerce_review_order_before_cart_contents' ); ?>
                            <div class='cd-order-data-wrapper'>
                                <div class='order-data order-data-title'>
                                    <div class='cd-data-name'>
                                        <?php esc_html_e( 'Product', 'codesigner-pro' ); ?>
                                    </div>
                                    <div class='cd-data'>
                                        <?php esc_html_e( 'Subtotal', 'codesigner-pro' ); ?>
                                    </div>
                                </div>
                                    <?php
                                        do_action( 'woocommerce_review_order_before_cart_contents' );

                                        foreach ( WC()->cart->get_cart() as $cart_item_key => $cart_item ) {
                                            $_product   = apply_filters( 'woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key );
                                            $image      = $_product->get_image();
                                            if ( $_product && $_product->exists() && $cart_item['quantity'] > 0 && apply_filters( 'woocommerce_checkout_cart_item_visible', true, $cart_item, $cart_item_key ) ) {
                                                ?>
                                                <div class='order-data order-data-products'>
                                                    <div class='cd-product-name'>
                                                        <?php echo $image; ?>
                                                        <p class='cd-light-color'>
                                                            <?php echo esc_html( $_product->get_title() ); ?>
                                                        </p>
                                                    </div>
                                                    <?php echo wc_get_formatted_cart_item_data( $cart_item ); ?>
                                                    <div class='cd-product-price cd-price-color'>
                                                        <?php echo apply_filters( 'woocommerce_cart_item_subtotal', WC()->cart->get_product_subtotal( $_product, $cart_item['quantity'] ), $cart_item, $cart_item_key ); ?>
                                                    </div>
                                                </div>
                                                <?php
                                            }
                                        }
                                        do_action( 'woocommerce_review_order_after_cart_contents' );
                                        ?>
                                    <table class="woocommerce-checkout-review-order-table" id="cd-checkout-tfoot-wrap">
                                        <tfoot id="cd-checkout-tfoot">
                                            <tr class="cart-subtotal">
                                                <th><?php esc_html_e( 'Subtotal', 'woocommerce' ); ?></th>
                                                <td><?php wc_cart_totals_subtotal_html(); ?></td>
                                            </tr>
                                            <?php foreach ( WC()->cart->get_coupons() as $code => $coupon ) : ?>
                                                <tr class="cart-discount coupon-<?php echo esc_attr( sanitize_title( $code ) ); ?>">
                                                    <th><?php wc_cart_totals_coupon_label( $coupon ); ?></th>
                                                    <td><?php wc_cart_totals_coupon_html( $coupon ); ?></td>
                                                </tr>
                                            <?php endforeach; ?>

                                            <?php if ( WC()->cart->needs_shipping() && WC()->cart->show_shipping() ) : ?>
                                                <?php do_action( 'woocommerce_review_order_before_shipping' ); ?>
                                                <?php WC()->cart->calculate_totals(); ?>
                                                <?php wc_cart_totals_shipping_html(); ?>
                                                <?php do_action( 'woocommerce_review_order_after_shipping' ); ?>
                                            <?php endif; ?>

                                            <?php foreach ( WC()->cart->get_fees() as $fee ) : ?>
                                                <tr class="fee">
                                                    <th><?php echo esc_html( $fee->name ); ?></th>
                                                    <td><?php wc_cart_totals_fee_html( $fee ); ?></td>
                                                </tr>
                                            <?php endforeach; ?>

                                            <?php if ( wc_tax_enabled() && ! WC()->cart->display_prices_including_tax() ) : ?>
                                                <?php if ( 'itemized' === get_option( 'woocommerce_tax_total_display' ) ) : ?>
                                                    <?php foreach ( WC()->cart->get_tax_totals() as $code => $tax ) : ?>
                                                        <tr class="tax-rate tax-rate-<?php echo esc_attr( sanitize_title( $code ) ); ?>">
                                                            <th><?php echo esc_html( $tax->label ); ?></th>
                                                            <td><?php echo wp_kses_post( $tax->formatted_amount ); ?></td>
                                                        </tr>
                                                    <?php endforeach; ?>
                                                <?php else : ?>
                                                    <tr class="tax-total">
                                                        <th><?php echo esc_html( WC()->countries->tax_or_vat() ); ?></th>
                                                        <td><?php wc_cart_totals_taxes_total_html(); ?></td>
                                                    </tr>
                                                <?php endif; ?>
                                            <?php endif; ?>
                                            <?php do_action( 'woocommerce_review_order_before_order_total' ); ?>
                                            <tr class="order-total">
                                                <th><?php esc_html_e( 'Total' , 'woocommerce' ); ?></th>
                                                <td><?php wc_cart_totals_order_total_html(); ?></td>
                                            </tr>
                                            <?php do_action( 'woocommerce_review_order_after_order_total' ); ?>
                                        </tfoot>
                                    </table>
                            </div></br>
                            <div class="cd-footer">
                                <div class="cd-back-to-cart">
                                    <?php if ( 'yes' == $back_to_cart_show_hide ) : ?>
                                        <span class="dashicons dashicons-arrow-left-alt"></span>
                                        <a href="<?php echo wc_get_cart_url(); ?>" class="cd-priv-btn"><?php esc_html_e( $back_to_cart_txt ); ?></a>
                                    <?php endif; ?>
                                </div>
                                <div class='cd-step-wrapper'>
                                    <div class="cd-previous">
                                        <?php if ( 'yes' == $back_to_cart_show_hide ) : ?>
                                            <button type="button" class='cd-priv-btn'>
                                                <?php esc_html_e( $prev_btn_txt ); ?>
                                            </button>
                                        <?php endif; ?>
                                    </div>
                                    <div class="cd-back-to-next">
                                        <?php if ( 'yes' == $back_to_cart_show_hide ) : ?>
                                            <button type="button" class='cd-next-btn'><?php esc_html_e( $nxt_btn_txt ); ?></button>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!--Payment Info Info-->
            <div class="select-payment-method">
                <div class="cd-checkout-steps-content">
                    <div class="cd-checkout-info payment">
                        <div class="cd-checkout-info-input ">
                            <div class="cd-checkout-payment cd-checkout-info payment-method">
                                <?php
                                if ( wp_doing_ajax() ) {
                                    do_action('woocommerce_review_order_before_payment');
                                }
                                ?>
                                <div id="payment" class="wc-checkout-payment">
                                    <?php if ( WC()->cart->needs_payment() ) : ?>
                                        <ul class="wc_payment_methods payment_methods methods">
                                            <?php
                                            $available_gateways = WC()->payment_gateways->get_available_payment_gateways();
                                            if ( ! empty( $available_gateways ) ) {
                                                $i = 1;
                                                foreach ( $available_gateways as $gateway ) {
                                                    ?>
                                                    <li class="<?php echo $i === 1 || checked( $gateway->chosen, true ) ? 'cd-select' : ''; ?> wc_payment_method payment_method_<?php echo esc_attr( $gateway->id ); ?>">
                                                        <label for="payment_method_<?php echo esc_attr( $gateway->id ); ?>">
                                                            <input id="payment_method_<?php echo esc_attr( $gateway->id ); ?>" type="radio" class="input-radio" name="payment_method" value="<?php echo esc_attr( $gateway->id ); ?>" <?php checked( $gateway->chosen, true ); ?> data-order_button_text="<?php echo esc_attr( $gateway->order_button_text ); ?>" />
                                                            <?php echo $gateway->get_title();?> <?php echo $gateway->get_icon(); ?>
                                                        </label>
                                                    <?php if ( $gateway->has_fields() || $gateway->get_description() ) : ?>
                                                        <div class="payment_box payment_method_<?php echo esc_attr( $gateway->id ); ?>">
                                                            <?php $gateway->payment_fields(); ?>
                                                        </div>
                                                    <?php endif; ?>
                                                </li>
                                                <?php
                                                 $i++;
                                                }
                                            } 
                                            else {
                                                echo '<li>';
                                                wc_print_notice( apply_filters( 'woocommerce_no_available_payment_methods_message', WC()->customer->get_billing_country() ? esc_html__('Sorry, it seems that there are no available payment methods. Please contact us if you require assistance or wish to make alternate arrangements.', 'woocommerce' ) : esc_html__( 'Please fill in your details above to see available payment methods.', 'woocommerce' ) ), 'notice' );
                                                echo '</li>';
                                            }
                                            ?>
                                        </ul>
                                    <?php endif;
                                    wc_get_template( 'checkout/terms.php' );
                                    ?>
                                    <div class="form-row place-order">
                                        <?php do_action( 'woocommerce_review_order_before_submit' ); ?>

                                        <?php echo apply_filters( 'woocommerce_order_button_html', 
                                        '<button type="submit" class="button alt' . esc_attr( 'button' ) . ' 
                                        name="woocommerce_checkout_place_order" id="place_order" value="' . 
                                        esc_attr('place') . '" data-value="' . esc_attr('place') . '">' .
                                        esc_html( $order_btn_txt ) . '</button>'); ?>

                                        <?php do_action( 'woocommerce_review_order_after_submit' ); ?>

                                        <?php wp_nonce_field( 'woocommerce-process_checkout', 'woocommerce-process-checkout-nonce' ); ?>
                                    </div>
                                <?php
                                if ( wp_doing_ajax() ) {
                                    do_action( 'woocommerce_review_order_after_payment' );
                                }
                                ?>
                                <div class="cd-footer">
                                    <div class="cd-back-to-cart">
                                        <?php if ( 'yes' == $back_to_cart_show_hide ) : ?>
                                            <span class="dashicons dashicons-arrow-left-alt"></span>
                                            <a href="<?php echo wc_get_cart_url(); ?>" class="cd-priv-btn"><?php esc_html_e( $back_to_cart_txt ); ?></a>
                                        <?php endif; ?>
                                    </div>
                                    <div class="cd-previous">
                                        <?php if ( 'yes' == $back_to_cart_show_hide ) : ?>
                                            <button type="button" class='cd-priv-btn'>
                                                <?php esc_html_e( $prev_btn_txt ); ?>
                                            </button>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>
